<?php include('tagging.php'); ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"> 
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en"> 
  <head> 
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" /> 
	<title>Simple Photo Tagging with jQuery and PHP</title>
	<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script> 
	<link rel="stylesheet" href="tagging.css" type="text/css" >
	
<script type="text/javascript">
  $(document).ready(function(){
    var counter = 0;
    var tagboxX = 0;
    var tagboxY = 0;
	var imageX = 0;
	var imageY = 0;
	var imgid = 0;
	var str = '';
	
	function adjustTagz( ) { //function to adjust the tag positions
		var img = $( ".imgcanvas" );
		id = $( img ).attr( 'id' );
		currW = $( img ).width( );
		currH = $( img ).height( );
		imgW = $( img )[0].naturalWidth;
		imgH = $( img )[0].naturalHeight;
		
		//alert( Math.round(  currW / imgW ) + " " + Math.round( currH / imgH ));
	
		$.each( tagpos[ id ], function( i, elem ) { //"tagpos" - json object that contains imgid and its tags and their positions - generated in tagging.php ( see from line 64 ) 
			pos = tagposition( elem.picx, elem.picy, currW, currH, imgW, imgH );
			$( '#view_' + elem.id ).css( { left: pos.picx, top: pos.picy } );
		});
		
		$( '.tagview').width(Math.round( (currW / imgW ) * 30)).height( Math.round( (currW / imgW ) * 30));
		$( '.square').height( Math.round( (currW / imgW ) * 30));
	}
			
	function tagposition( picx, picy, crwidth, crheight, origw, origh ) { 
			var pos = new Array( );
				if(( crwidth <  origw ) || ( crwidth > origw ) ) {
					
					picx = Math.round( ((  crwidth / origw ) * picx ));
					picy = Math.round( ((  crheight / origh  ) * picy ));
				}
				
				pos[ 'picx' ] = picx;	pos[ 'picy' ] = picy;
				return pos;
	}
	
 	$( window ).resize( function( ) { //adjust tag positions when window resized
				adjustTagz( );
	}); 
	
	// load the tags for the image when page loads.
    var img = $('.tagz').find( 'img' );
	var id = $( img ).attr( 'id' );
	viewtag( id ); // view all tags available on page load

    function viewtag( pic_id )
    {
      // get the tag list with action remove and tag boxes and place it on the image.
	  $.post( "ajax.php" ,  "pic_id=" + pic_id + "&action=view", function( data ) {
		
	  	$('#taglist ol').html(data.lists);
		$('#tagbox_' + pic_id ).html(data.boxes);
		adjustTagz( ); //adjust the tag positions while loading the tags
		
	  }, "json");
	  
    }
			

    
    $(".imgcanvas").click(function(e) { // make sure the image is click
		
     
	 imgid = $( this ).attr( 'id' );  /*get the image id. ( eg id="1" ) */
	 var imgtag = '#img_' + imgid;  /* get the parent div of the image ( eg "img_1"  ) */
	 
	 	/* calculate the position of the click on the image */
 	 	var offset_l = $( this ).offset( ).left - $( window ).scrollLeft( );  
		var offset_t = $( this ).offset( ).top - $( window ).scrollTop( );
		imageX = divX = Math.round( ( e.clientX - offset_l ) );  /* get imageX */
		imageY = divY = Math.round( ( e.clientY - offset_t ) );  /*get iamgeY */
		
		imgW = $(this)[0].naturalWidth;
		imgH = $(this)[0].naturalHeight;
		
		currW = $(this).width();
		currH = $(this).height();
		
		tagboxX = imageX - Math.round(( currW / imgW ) * 15);
		tagboxY = imageY - Math.round(( currH /imgH ) * 15);
		
		
		if((currW > imgW )  || (currW < imgW )) {
			
			imageX = Math.round((imgW / currW ) * imageX);
			imageY= Math.round((imgH / currH) * imageY);
		}
		
		$( '#stats' ).html( 
				'<ul><li>Image X: ' + imageX + '</li><li>Image Y: ' + imageY + '</li><li>Div X: ' + divX + '</li><li>Div Y: ' + divY + '</li><li>TagBox X: ' + tagboxX + '</li><li>TagBox Y: ' + tagboxY + '</li><li>Curr imgW:' + currW + '</li><li>Curr imgH:' + currH + '</li>' +
				'<li>Orig imgW:' + imgW + '</li><li>Orig imgH:' + imgH + '</li><li>Tagbox Sz:' + Math.round( (currW / imgW ) * 30) + '</li></ul>'
		);
		
      $( '#tagit' ).remove( ); // remove any tagit div first
      $( imgtag ).append( '<div id="tagit"><div class="box"></div><div class="name"><div class="text">Type any name or tag</div><input type="text" name="txtname" class="search" id="tagname" /><div id="result"></div><input type="button" name="btnsave" value="Save" id="btnsave" /><input type="button" name="btncancel" value="Cancel" id="btncancel" /></div></div>' );
      $( '#tagit' ).css({ top:tagboxY, left:tagboxX });
	  $( '#tagit .box').width(Math.round( (currW / imgW ) * 30)).height( Math.round( (currW / imgW ) * 30));
      
      $('#tagname').focus();
    });
	
	// autocomplete 
	
	// check for input and send an ajax request with the characters typed.
	
	$( ".tagz" ).on( 'keyup', '#tagname', function() {
		str = $(this).val();
		if( str != '' ) {
			$.post( "ajax.php", "search=" + str + "&action=search", function( data ) {
				$( "#result" ).html( data ).show(); //show the query results in div.
			});
		}
			
	});
	
	// hide the result div when clicked away from the input.
	$( document ).click( function( e ) {
		var $clicked = $( e.target );
		if (! $clicked.hasClass("search") ) {
			$( '#result' ).fadeOut();
		}
	});
	
	// show the result div when clicked on the input.
	$( '.tagz' ).on( 'click', '#tagname', function() {
		if( $.trim( $("#result").text() ) != '' ) {
			$( '#result' ).fadeIn();
		}
	});
	
	// fill the input with the value selected from the auto search result.
	$( ".tagz" ).on( 'click', '.ntag', function(e) { 
		var txt = $(this).text();
		$( '#tagname' ).val( txt );
	});
	
    
	// Save button click - save tags
    $( document ).on( 'click',  '#tagit #btnsave', function(){
      name = $('#tagname').val();
		var img = $('.tagz').find( 'img' );
		var id = $( img ).attr( 'id' );
      $.ajax({
        type: "POST", 
        url: "ajax.php", 
        data: "pic_id=" + id + "&name=" + name + "&pic_x=" + imageX + "&pic_y=" + imageY + "&action=insert",
        cache: true, 
        success: function(data) {
		 	
          viewtag( id );
          $('#tagit').fadeOut();
        }
      });
      
    });
    
	// Cancel the tag box.
    $( document ).on( 'click', '#tagit #btncancel', function() {
      $('#tagit').fadeOut();
    });
    
	// mouseover the taglist 
	$('#taglist').on( 'mouseover', 'li', function( ) {
      id = $(this).attr("id");
      $('#view_' + id).css({ opacity: 1.0 });
    }).on( 'mouseout', 'li', function( ) {
        $('#view_' + id).css({ opacity: 0.0 });
    });
	
	// mouseover the tagboxes that is already there but opacity is 0.
	$( '.content' ).on( 'mouseover', '.tagview', function( ) {
		var pos = $( this ).position();
		$(this).css({ opacity: 1.0 }); // div appears when opacity is set to 1.
	}).on( 'mouseout', '.tagview', function( ) {
		$(this).css({ opacity: 0.0 }); // hide the div by setting opacity to 0.
	});
    
	// Remove tags.
    $( '#taglist' ).on('click', '.remove', function() {
      id = $(this).parent().attr("id");
      // Remove the tag
	  $.ajax({
        type: "POST", 
        url: "ajax.php", 
        data: "tag_id=" + id + "&action=delete",
        success: function(data) {
			var img = $('.tagz').find( 'img' );
			var id = $( img ).attr( 'id' );
			//get tags if present
			viewtag( id );
        }
      });
    }); 
    
  });
</script> 
  </head> 
  <body>
   	<div id="logo">
		<h1>
			<a href="https://techlister.com/image-tagging/" title="Ajax File Upload with PHP and jQuery"><img src="https://techlister.com/wp-content/uploads/2019/01/techlister.jpg" alt="Ajax File Upload" title="jQuery Ajax file upload" border="0" style="border: 0px;" /></a>
		</h1>
		<div id="pgtitle">
			<a href="https://techlister.com/php/simple-photo-tagging-with-php-and-jquery/1176/" title="Simple Photo Tagging with jQuery and PHP">Simple Photo Tagging with jQuery and PHP</a>
			<p>Added Auto Complete Search</p>
		</div>
	</div>
	
<div class="content">
  <div class='container' style='width:100%'>
  <div id="Testslider"> 
  <div class="tagz">
    <?php 
    echo $tag->fetch_image( 1 );
  ?>
  </div>
  </div> 
  </div>
  
  <div id="taglist"> 
    <ol> 
    </ol> 
  </div> 
  
  	<div id="stats">
	</div>
</div>

  </body>
</html>